package com.example.tp6_03.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.example.tp6_03.R;
import com.example.tp6_03.model.WeatherCondition;

import java.util.List;

public class ListViewAdapterWeatherCondition extends BaseAdapter {
    Context context;
    int layout_id;
    List<WeatherCondition> items;

    public ListViewAdapterWeatherCondition(final Context context, final int layout_id,final List<WeatherCondition> items) {
        this.context = context;
        this.items = items;
        this.layout_id = layout_id;
    }

    public void setItems(final List<WeatherCondition> items){
        this.items = items;
    }

    @Override
    public int getCount() {
        return this.items.size();
    }

    @Override
    public Object getItem(int position) {
        return this.items.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View itemView = null;
        final WeatherCondition day = this.items.get(position);
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            itemView = inflater.inflate(layout_id, null);
        } else {
            itemView = convertView;
        }

        TextView weather_date = (TextView) itemView.findViewById(R.id.weather_date);
        weather_date.setText(day.getDate());

        TextView weather_min = (TextView) itemView.findViewById(R.id.weather_min);
        weather_min.setText(String.valueOf(day.getMin()));

        TextView weather_max = (TextView) itemView.findViewById(R.id.weather_max);
        weather_max.setText(String.valueOf(day.getMax()));

        ImageView imageView = (ImageView) itemView.findViewById(R.id.thumbImage);
        imageView.setImageBitmap(day.getIcon());

        return itemView;

    }
}
